#include<stdlib.h>
#include<math.h>
#include<utility>
#include<stack>
#include<set>
#include<vector>
#include<map>
#include<BWAPI.h>

using namespace std;
using namespace BWAPI;

#define ROW 128
#define COL 128

int numSteps = 0;

// Creating a shortcut for int, int pair type 
typedef pair<int, int> Pair;

// Creating a shortcut for pair<int, pair<int, int>> type 
typedef pair<double, pair<int, int>> pPair;

// A structure to hold the neccesary parameters 
struct cell
{
	// Row and Column index of its parent 
	// Note that 0 <= i <= ROW-1 & 0 <= j <= COL-1 
	int parent_i, parent_j;
	// f = g + h 
	double f, g, h;
};

// A Utility Function to check whether given cell (row, col) 
// is a valid cell or not. 
bool isValid(int row, int col)
{
	// Returns true if row number and column number is in range 
	//cout << "isValid? " << row << ", " << col << ", " << ROW << ", " << COL << endl;

	return (row >= 0) && (row < ROW) &&
		(col >= 0) && (col < COL);
}

// A Utility Function to check whether the given cell is 
// blocked or not 
bool isUnBlocked(int grid[][COL], int row, int col) // [COL]
{
	// Returns true if the cell is not blocked else false 
	if (grid[row][col] == 0)
		return (true);
	else
		return (false);
}

// A Utility Function to check whether destination cell has 
// been reached or not 
bool isDestination(int row, int col, Pair dest)
{
	if (row == dest.first && col == dest.second)
		return (true);
	else
		return (false);
}

// A Utility Function to calculate the 'h' heuristics. 
double calculateHValue(int row, int col, Pair dest)
{
	// Return using the distance formula 
	return ((double)sqrt((row - dest.first)*(row - dest.first)
		+ (col - dest.second)*(col - dest.second)));
}

// A Utility Function to trace the path from the source 
// to destination 
double tracePath(cell cellDetails[][COL], Pair dest, TilePosition * nextPos) // [COL]
{
	int row = dest.first;
	int col = dest.second;

	stack<Pair> Path;

	while (!(cellDetails[row][col].parent_i == row
		&& cellDetails[row][col].parent_j == col))
	{
		Path.push(make_pair(row, col));
		int temp_row = cellDetails[row][col].parent_i;
		int temp_col = cellDetails[row][col].parent_j;
		row = temp_row;
		col = temp_col;
	}

	Path.push(make_pair(row, col));
	double pathLength = 0.0;
	stack<Pair> Path0 = Path;
	stack<Pair> Path1 = Path;
	Path1.pop();

	//nextPos->push_back(Path1.top().first);
	//nextPos->push_back(Path1.top().second);
	nextPos->x = Path1.top().first;
	nextPos->y = Path1.top().second;

	int pathSize = Path1.size();
	for (int i = 0; i < pathSize; i++)
	{
		pathLength += calculateHValue(Path0.top().first, Path0.top().second, Path1.top());
		Path0.pop();
		Path1.pop();
	}

	while (!Path.empty())
	{
		pair<int, int> p = Path.top();
		Path.pop();
	}

	return pathLength;
}

// A Function to find the shortest path between 
// a given source cell to a destination cell according 
// to the Custom Search Algorithm 
double pathSearch(int grid[][COL], Pair src, Pair dest, TilePosition * nextPos) // [COL]
{
	// If the source is out of range 
	if (isValid(src.first, src.second) == false)
	{
		return 10.0 * ROW * COL;
	}

	// If the destination is out of range 
	if (isValid(dest.first, dest.second) == false)
	{
		return 10.0 * ROW * COL;
	}

	// Either the source or the destination is blocked 
	if (isUnBlocked(grid, src.first, src.second) == false ||
		isUnBlocked(grid, dest.first, dest.second) == false)
	{
		return 10.0 * ROW * COL;
	}

	// If the destination cell is the same as source cell 
	if (isDestination(src.first, src.second, dest) == true)
	{
		return 0.0;
	}

	// Create a closed list and initialise it to false which means 
	// that no cell has been included yet 
	// This closed list is implemented as a boolean 2D array 
	bool closedList[ROW][COL];
	memset(closedList, false, sizeof(closedList));

	// Declare a 2D array of structure to hold the details of that cell 
	//vector<vector<cell>> cellDetails(ROW, vector<cell>(COL)); // [COL]
	cell cellDetails[ROW][COL];

	int i, j;

	for (i = 0; i < ROW; i++)
	{
		for (j = 0; j < COL; j++)
		{
			cellDetails[i][j].f = FLT_MAX;
			cellDetails[i][j].g = FLT_MAX;
			cellDetails[i][j].h = FLT_MAX;
			cellDetails[i][j].parent_i = -1;
			cellDetails[i][j].parent_j = -1;
		}
	}

	// Initialising the parameters of the starting node 
	i = src.first, j = src.second;
	cellDetails[i][j].f = 0.0;
	cellDetails[i][j].g = 0.0;
	cellDetails[i][j].h = 0.0;
	cellDetails[i][j].parent_i = i;
	cellDetails[i][j].parent_j = j;

	/*
	Create an open list having information as-
	<f, <i, j>>
	where f = g + h,
	and i, j are the row and column index of that cell
	Note that 0 <= i <= ROW-1 & 0 <= j <= COL-1
	This open list is implenented as a set of pair of pair.*/
	set<pPair> openList;

	// Put the starting cell on the open list and set its 
	// 'f' as 0 
	openList.insert(make_pair(0.0, make_pair(i, j)));

	// We set this boolean value as false as initially 
	// the destination is not reached. 
	bool foundDest = false;
	//vector<vector<int> > numVisits(ROW, vector<int>(COL, 0)); // [COL]
	int numVisits[ROW][COL] = {};

	while (!openList.empty())
	{
		pPair p = *openList.begin();

		// Remove this vertex from the open list 
		openList.erase(openList.begin());

		// Add this vertex to the closed list 
		i = p.second.first;
		j = p.second.second;
		closedList[i][j] = true;

		/*
		Generating all the 8 successor of this cell

		N.W   N     N.E
		  \   |    /
			\ |  /
		W----Cell----E
			/ |  \
		  /   |   \
		S.W   S    S.E

		Cell-->Popped Cell (i, j)
		N -->  North       (i-1, j)
		S -->  South       (i+1, j)
		E -->  East        (i, j+1)
		W -->  West        (i, j-1)
		N.E--> North-East  (i-1, j+1)
		N.W--> North-West  (i-1, j-1)
		S.E--> South-East  (i+1, j+1)
		S.W--> South-West  (i+1, j-1)*/

		// To store the 'g', 'h' and 'f' of the 8 successors 
		double gNew, hNew, fNew;

		vector<vector<int>> allDirections = { {i - 1, j}, {i + 1, j}, {i, j + 1}, {i, j - 1},
											 {i - 1, j + 1}, {i - 1, j - 1}, {i + 1, j + 1}, {i + 1, j - 1} };

		 // if using the standard A*
		for (auto u : allDirections)
		{
			int ind1 = u.front();
			int ind2 = u.back();
			// Only process this cell if this is a valid one 
			if (isValid(ind1, ind2) == true)
			{
				// If the destination cell is the same as the 
				// current successor 
				if (isDestination(ind1, ind2, dest) == true)
				{
					// Set the Parent of the destination cell 
					cellDetails[ind1][ind2].parent_i = i;
					cellDetails[ind1][ind2].parent_j = j;
					foundDest = true;
					return tracePath(cellDetails, dest, nextPos);
				}
				// If the successor is already on the closed 
				// list or if it is blocked, then ignore it. 
				// Else do the following 
				else if (closedList[ind1][ind2] == false &&
					isUnBlocked(grid, ind1, ind2) == true)
				{
					gNew = cellDetails[i][j].g + 1.0;
					hNew = calculateHValue(ind1, ind2, dest);
					fNew = gNew + hNew;

					// If it isn't on the open list, add it to 
					// the open list. Make the current square 
					// the parent of this square. Record the 
					// f, g, and h costs of the square cell 
					//                OR 
					// If it is on the open list already, check 
					// to see if this path to that square is better, 
					// using 'f' cost as the measure. 
					if (cellDetails[ind1][ind2].f == FLT_MAX ||
						cellDetails[ind1][ind2].f > fNew)
					{
						openList.insert(make_pair(fNew,
							make_pair(ind1, ind2)));

						// Update the details of this cell 
						cellDetails[ind1][ind2].f = fNew;
						cellDetails[ind1][ind2].g = gNew;
						cellDetails[ind1][ind2].h = hNew;
						cellDetails[ind1][ind2].parent_i = i;
						cellDetails[ind1][ind2].parent_j = j;

						numSteps++;
					}
				}
			}
		} // Loop through all directions
	} // while (!openList.empty()) 

	// When the destination cell is not found and the open 
	// list is empty, then we conclude that we failed to 
	// reach the destiantion cell. This may happen when the 
	// there is no way to destination cell (due to blockages) 

	return 10.0 * ROW * COL;
} // int pathSearch(...) 


// Driver program to test above function 
// [[Rcpp::export]]
TilePosition runPathSearch(int grid0[][COL], TilePosition src0, vector<int> dest0)
{
	// Create a 2D vector with user-defined sizes: https://www.geeksforgeeks.org/2d-vector-in-cpp-with-user-defined-size/
	//vector<vector<int>> grid(ROW, vector<int>(COL)); // [COL]
	int grid[ROW][COL];

	for (int i = 0; i < ROW; i++)
		for (int j = 0; j < COL; j++)
			grid[i][j] = grid0[i][j];

	/* Description of the Grid-
	 0--> The cell is not blocked
	 1--> The cell is blocked    */
	Pair src = make_pair(src0.x, src0.y);
	Pair dest = make_pair(dest0.front(), dest0.back());

	TilePosition nextPos;
	pathSearch(grid, src, dest, &nextPos);

	/*if (nextPos.empty()) {
		vector<int> vec00 = { 0, 0 };
		return vec00;
	}*/

	if (!(nextPos && nextPos != TilePositions::None)) return TilePosition(0, 0);

	return nextPos;
}
